﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="VeteransAffairs.Registries.BusinessManager" %>
<%@ Import Namespace="System.Web.Configuration" %>


<script runat="server">

    void Application_PostAuthenticateRequest(object sender, EventArgs e)
    {
        // Fires upon attempting to authenticate the user
        if (HttpContext.Current.Request.Url.PathAndQuery.IndexOf(".aspx") > 0)
        {
            if (Context.Request.IsAuthenticated)
            {
                string userId = HttpContext.Current.User.Identity.Name; // this.User.Identity.Name;
                string Registry = Helpers.GetConfigEntry("Registry");
                HttpContext.Current.User = new UserAccountManager(userId, Registry);
                System.Threading.Thread.CurrentPrincipal = HttpContext.Current.User;
            }
            else
            {
                Response.Write("Not authenticated.");
                Response.Write("<br>");
                Response.Write(HttpContext.Current.Request.Url.PathAndQuery);
                Response.End();
            }
        }
    }

    void Application_BeginRequest(object sender, EventArgs e)
    {
        string originalPath = Request.Url.ToString();

        if (originalPath.EndsWith("/Referrals.aspx", StringComparison.CurrentCultureIgnoreCase))
        {
            HttpContext.Current.RewritePath("~/Referrals.aspx?statusId=4", true);
            Response.Redirect("~/Referrals.aspx?statusId=4");
        }

        if (originalPath.EndsWith("/Surveys.aspx", StringComparison.CurrentCultureIgnoreCase))
        {
            HttpContext.Current.RewritePath("~/Surveys.aspx?status=6", true);
            Response.Redirect("~/Surveys.aspx?status=6");
        }

        if (originalPath.EndsWith("/LabOrders.aspx", StringComparison.CurrentCultureIgnoreCase))
        {
            HttpContext.Current.RewritePath("~/LabOrders.aspx?status=6", true);
            Response.Redirect("~/LabOrders.aspx?status=6");
        }

        this.Response.Headers["X-Content-Type-Options"] = "nosniff";
    }

</script>
